<?php
// functions.php

/**
 * Make an API request using cURL.
 */
function makeApiRequest($url, $data, $apiSecret) {
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiSecret,
        'Content-Type: application/json',
        'accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);

    // Check if the request was successful
    if ($httpCode == 200) {
        $responseData = json_decode($response, true);
        return $responseData; // Return the full response data
    }

    return false;
}

/**
 * Create a PalmPay account using the API.
 */
function createPalmPayAccount($firstName, $lastName, $email, $phone, $userId, $apiSecret) {
    $url = "https://api-v1.aspfiy.com/reserve-palmpay/";
    $data = [
        "email" => $email,
        "reference" => "user_" . $userId, // Unique reference for the user
        "firstName" => $firstName,
        "lastName" => $lastName,
        "webhookUrl" => "https://inyass.com.ng/webhook/palmpay.php", // Replace with your webhook URL
        "phone" => $phone
    ];

    return makeApiRequest($url, $data, $apiSecret);
}

/**
 * Create a Paga account using the API.
 */
function createPagaAccount($firstName, $lastName, $email, $phone, $userId, $apiSecret) {
    $url = "https://api-v1.aspfiy.com/reserve-paga/";
    $data = [
        "email" => $email,
        "reference" => "user_" . $userId, // Unique reference for the user
        "firstName" => $firstName,
        "lastName" => $lastName,
        "webhookUrl" => "https://inyass.com.ng/webhook/paga.php", // Replace with your webhook URL
        "phone" => $phone
    ];

    return makeApiRequest($url, $data, $apiSecret);
}
?>