
  
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Transactions</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
     <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <title>Dashboard</title>
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="images/logo.png" />
    <link rel="apple-touch-icon-precomposed" href="images/logo.png" />
    <!-- Font -->
    <link rel="stylesheet" href="fonts/fonts.css" />
    <!-- Icons -->
    <link rel="stylesheet" href="fonts/icons-alipay.css">
    <link rel="stylesheet" href="styles/bootstrap.css">
    <link rel="stylesheet" href="styles/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="styles/styles.css" />
    <link rel="manifest" href="_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js">
    <link rel="apple-touch-icon" sizes="192x192" href="app/icons/icon-192x192.png">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        /* Add this CSS to create a 3x3 grid layout */
        .box-service {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 16px; /* Adjust the gap between grid items as needed */
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .box-service li {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            background-color: #f9f9f9; /* Optional: Add background color */
            padding: 16px;
            border-radius: 8px; /* Optional: Add rounded corners */
        }

        .box-service li a {
            text-decoration: none;
            color: inherit;
        }

        .icon-box {
            font-size: 24px; /* Adjust the size of the icon */
            margin-bottom: 8px; /* Space between icon and text */
        }
    </style>
</head>
<body>
        <div class="app-header">
        <div class="tf-container">
            <div class="tf-topbar d-flex justify-content-between align-items-center">
                <a class="user-info d-flex justify-content-between align-items-center" href="profile.php">
                    <img src="images/user/user1.jpg" alt="image">

                    <div class="content">
                        <h4 class="white_color"> <?php echo $fullname; ?></h4>
                        <p class="white_color fw_4"><?php echo ucfirst($user_type); ?></p>
                    </div>
                </a>
               
            </div>
        </div>
    </div>
    <div class="card-secton">
        <div class="tf-container">
            <div class="tf-balance-box">
                <div class="balance">
                    <div class="row">
                        <div class="col-6 br-right">
                            <div class="inner-left">
                                <p>Your Balance:</p>
                               <h2>
    <span id="wallet-balance">₦****</span>
    <span id="toggle-eye" class="eye-icon" style="cursor: pointer;">👁️</span>
</h2>

<script>
    const eyeIcon = document.getElementById('toggle-eye');
    const walletBalance = document.getElementById('wallet-balance');

    // Replace with actual wallet balance from PHP
    const rawBalance = "<?php echo $wallet_balance; ?>"; // e.g., 25000.75

    // Format the balance with comma separators and two decimal points
    const formattedBalance = "₦" + parseFloat(rawBalance).toLocaleString('en-NG', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });

    let isVisible = false;

    eyeIcon.addEventListener('click', () => {
        if (isVisible) {
            walletBalance.textContent = '****';
            eyeIcon.textContent = '👁️';
        } else {
            walletBalance.textContent = formattedBalance; // Show formatted number with ₦
            eyeIcon.textContent = '🙈';
        }
        isVisible = !isVisible;
    });
</script>

                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="wallet-footer">
                    <!-- Include Font Awesome CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<ul class="d-flex justify-content-between align-items-center" style="list-style: none; padding: 0;">
    
    <!-- Fund Account -->
    <li class="wallet-card-item" style="text-align: center;">
        <a href="account.php" class="fw_6 text-center" id="btn-popup-down" style="text-decoration: none; color: inherit;">
            <div class="icon-container">
                <i class="fas fa-wallet fa-2x"></i>
            </div>
            <div>Fund Account</div>
        </a>
    </li>

    <!-- Transactions -->
    <li class="wallet-card-item" style="text-align: center;">
        <a href="buy_data.php" class="fw_6 btn-card-popup" style="text-decoration: none; color: inherit;">
            <div class="icon-container">
                <i class="fas fa-signal fa-2x"></i>
            </div>
            <div>Transactions</div>
        </a>
    </li>

    <!-- Airtime -->
    <li class="wallet-card-item" style="text-align: center;">
        <a href="buyairtime.php" class="fw_6" style="text-decoration: none; color: inherit;">
            <div class="icon-container">
                <i class="fas fa-mobile-alt fa-2x"></i>
            </div>
            <div>Airtime</div>
        </a>
    </li>

</ul>

                </div>
            </div>
        </div>

    </div>
    
    
    <style>
        .uu{
            width: 100%;
            padding: 6px;
        }
        
    </style>
    
     <div class="mt-5 mb-9">
        <div class="tf-container">
    <div class="uu">
    <h4>Transactions</h4>
   
   
   
   
   
   
   
   
   
   
   
   
<?php
session_start();

// Prevent session fixation
session_regenerate_id(true);

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require 'require/conn.php';

// Sanitize function (defined once)
function sanitizeOutput($data) {
    return htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
}

// Get session data (already sanitized for display use)
$user_id   = intval($_SESSION['user_id']);
$firstName = sanitizeOutput($_SESSION['firstName']);
$lastName  = sanitizeOutput($_SESSION['lastName']);
$fullname  = "$firstName $lastName";
$email     = sanitizeOutput($_SESSION['email']);
$phone     = sanitizeOutput($_SESSION['phone']);
$user_type = sanitizeOutput($_SESSION['type']);

// ===============================
// Fetch user details from database
// ===============================
$stmt = $conn->prepare("SELECT firstName, lastName, wallet_balance, transaction_pin FROM jamaa WHERE id = ?");
if (!$stmt) {
    die("Error in prepare(): " . $conn->error);
}
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows !== 1) {
    echo "User not found.";
    exit();
}

$user = $result->fetch_assoc();

// Re-sanitize fetched data
$firstName       = htmlspecialchars($user['firstName']);
$lastName        = htmlspecialchars($user['lastName']);
$wallet_balance  = htmlspecialchars($user['wallet_balance']);
$transaction_pin = htmlspecialchars($user['transaction_pin']);

// ===============================
// Pagination setup
// ===============================
$records_per_page = 25; // Number of records per page
$page = isset($_GET['page']) ? intval($_GET['page']) : 1; // Current page
$offset = ($page - 1) * $records_per_page; // Offset for SQL query

// ===============================
// Fetch transactions
// ===============================
$transactions_query = "SELECT 
                          transaction_ref, 
                          amount, 
                          old_balance, 
                          new_balance, 
                          transaction_type, 
                          status, 
                          description, 
                          created_at  -- Removed phone column
                      FROM transactions 
                      WHERE user_id = ? 
                      ORDER BY created_at DESC 
                      LIMIT ? OFFSET ?";
$stmt_tx = $conn->prepare($transactions_query);
if (!$stmt_tx) {
    die("Error in prepare(): " . $conn->error);
}
$stmt_tx->bind_param("iii", $user_id, $records_per_page, $offset);
$stmt_tx->execute();
$result_tx = $stmt_tx->get_result();

// ===============================
// Fetch airtime transactions
// ===============================
$airtime_query = "SELECT 
                     id, 
                     network, 
                     amount, 
                     phone,  -- No alias needed
                     status, 
                     old_wallet_balance, 
                     new_wallet_balance, 
                     created_at 
                 FROM airtimetransactions 
                 WHERE user_id = ? 
                 ORDER BY created_at DESC 
                 LIMIT ? OFFSET ?";
$stmt_airtime = $conn->prepare($airtime_query);
if (!$stmt_airtime) {
    die("Error in prepare(): " . $conn->error);
}
$stmt_airtime->bind_param("iii", $user_id, $records_per_page, $offset);
$stmt_airtime->execute();
$result_airtime = $stmt_airtime->get_result();

// ===============================
// Fetch data purchases
// ===============================
$data_query = "SELECT 
                  id, 
                  data_name, 
                  price, 
                  mobile_no AS phone,  -- Alias mobile_no as phone
                  reference, 
                  status, 
                  error_message, 
                  old_balance, 
                  new_balance, 
                  deducted, 
                  created_at 
              FROM data_purchases 
              WHERE user_id = ? 
              ORDER BY created_at DESC 
              LIMIT ? OFFSET ?";
$stmt_data = $conn->prepare($data_query);
if (!$stmt_data) {
    die("Error in prepare(): " . $conn->error);
}
$stmt_data->bind_param("iii", $user_id, $records_per_page, $offset);
$stmt_data->execute();
$result_data = $stmt_data->get_result();

// ===============================
// Count total records for pagination
// ===============================
$total_transactions = $conn->query("SELECT COUNT(*) FROM transactions WHERE user_id = $user_id")->fetch_row()[0];
$total_airtime = $conn->query("SELECT COUNT(*) FROM airtimetransactions WHERE user_id = $user_id")->fetch_row()[0];
$total_data = $conn->query("SELECT COUNT(*) FROM data_purchases WHERE user_id = $user_id")->fetch_row()[0];
$total_records = $total_transactions + $total_airtime + $total_data;

// Calculate total pages
$total_pages = ceil($total_records / $records_per_page);
?>


  <style>
        table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            border-radius: 5px;
            overflow: hidden;
        }
        th, td {
            padding: 10px 12px;
            border-bottom: 1px solid #ccc;
            text-align: left;
        }
        th {
            background-color: green;
            color: white;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .no-transactions {
            text-align: center;
            padding: 20px;
            background: #fff3cd;
            border: 1px solid #ffeeba;
            color: #856404;
            border-radius: 4px;
        }
        .pagination {
            margin-top: 20px;
            text-align: center;
        }
        .pagination a {
            padding: 8px 16px;
            text-decoration: none;
            color: #28a745;
            border: 1px solid #ddd;
            margin: 0 4px;
        }
        .pagination a.active {
            background-color: #28a745;
            color: white;
            border: 1px solid #28a745;
        }
        .pagination a:hover:not(.active) {
            background-color: #ddd;
        }
    </style>


              <?php if ($result_tx->num_rows > 0 || $result_airtime->num_rows > 0 || $result_data->num_rows > 0): ?>
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Type</th>
                            <th>Amount (₦)</th>
                            <th>Old Balance (₦)</th>
                            <th>New Balance (₦)</th>
                            <th>Phone</th> <!-- Common column for phone -->
                            <th>Status</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $count = 1;
                        // Display transactions
                        while ($tx = $result_tx->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $count++; ?></td>
                                <td><?php echo sanitizeOutput($tx['transaction_type']); ?></td>
                                <td><?php echo number_format($tx['amount'], 2); ?></td>
                                <td><?php echo number_format($tx['old_balance'], 2); ?></td>
                                <td><?php echo number_format($tx['new_balance'], 2); ?></td>
                                <td>N/A</td> <!-- No phone column in transactions -->
                                <td style="color: <?php
                                    if ($tx['status'] === 'success') {
                                        echo 'green';
                                    } elseif ($tx['status'] === 'pending') {
                                        echo 'orange';
                                    } elseif ($tx['status'] === 'failed') {
                                        echo 'red';
                                    } else {
                                        echo 'black'; // Default color
                                    }
                                ?>;">
                                    <?php echo ucfirst(sanitizeOutput($tx['status'])); ?>
                                </td>
                                <td><?php echo sanitizeOutput($tx['created_at']); ?></td>
                            </tr>
                        <?php endwhile; ?>

                        <!-- Display airtime transactions -->
                        <?php while ($airtime = $result_airtime->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $count++; ?></td>
                                <td>Airtime</td>
                                <td><?php echo number_format($airtime['amount'], 2); ?></td>
                                <td><?php echo number_format($airtime['old_wallet_balance'], 2); ?></td>
                                <td><?php echo number_format($airtime['new_wallet_balance'], 2); ?></td>
                                <td><?php echo sanitizeOutput($airtime['phone']); ?></td> <!-- Phone column -->
                                <td style="color: <?php
                                    if ($airtime['status'] === 'success') {
                                        echo 'green';
                                    } elseif ($airtime['status'] === 'pending') {
                                        echo 'orange';
                                    } elseif ($airtime['status'] === 'failed') {
                                        echo 'red';
                                    } else {
                                        echo 'black'; // Default color
                                    }
                                ?>;">
                                    <?php echo ucfirst(sanitizeOutput($airtime['status'])); ?>
                                </td>
                                <td><?php echo sanitizeOutput($airtime['created_at']); ?></td>
                            </tr>
                        <?php endwhile; ?>

                        <!-- Display data purchases -->
                        <?php while ($data = $result_data->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $count++; ?></td>
                                <td>Data Purchase</td>
                                <td><?php echo number_format($data['price'], 2); ?></td>
                                <td><?php echo number_format($data['old_balance'], 2); ?></td>
                                <td><?php echo number_format($data['new_balance'], 2); ?></td>
                                <td><?php echo sanitizeOutput($data['phone']); ?></td> <!-- Phone column (aliased from mobile_no) -->
                                <td style="color: <?php
                                    if ($data['status'] === 'success') {
                                        echo 'green';
                                    } elseif ($data['status'] === 'pending') {
                                        echo 'orange';
                                    } elseif ($data['status'] === 'failed') {
                                        echo 'red';
                                    } else {
                                        echo 'black'; // Default color
                                    }
                                ?>;">
                                    <?php echo ucfirst(sanitizeOutput($data['status'])); ?>
                                </td>
                                <td><?php echo sanitizeOutput($data['created_at']); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>

                <!-- Pagination -->
                <div class="pagination">
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <a href="?page=<?php echo $i; ?>" class="<?php echo ($page == $i) ? 'active' : ''; ?>"><?php echo $i; ?></a>
                    <?php endfor; ?>
                </div>
            <?php else: ?>
                <div class="no-transactions">
                    You have no transactions yet.
                </div>
            <?php endif; ?>
 
       
       
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   </div>
   </div>
      </div>
   <div class="bottom-navigation-bar">
        <div class="tf-container">
            <ul class="tf-navigation-bar">
                <li ><a class="fw_6 d-flex justify-content-center align-items-center flex-column"
                        href="account.php"> <i class="fas fa-wallet fa-2x"></i> Fund</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="history.php"><i
                            class="icon-history"></i> History</a> </li>
                <li class="active"><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="dashboard.php"><i
                            class="icon-home2"></i> </a>  </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column"
                        href="privacy.php">  <i class="fas fa-flag fa-2x"></i></i>
                        Privacy</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="profile.php"><i
                            class="icon-user-outline"></i> Profile</a> </li>
            </ul>
            <!-- <span class="line"></span> -->
        </div>
    </div>
  


 </div>   </div>
    <script type="text/javascript" src="javascript/jquery.min.js"></script>
    <script type="text/javascript" src="javascript/bootstrap.min.js"></script>
    <script type="text/javascript" src="javascript/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="javascript/swiper.js"></script>
    <script type="text/javascript" src="javascript/main.js"></script>
</body>
</html>










        

