<?php

function createPalmPayAccount($firstName, $lastName, $email, $phone, $userId, $apiSecret) {
    $url = "https://api-v1.aspfiy.com/reserve-palmpay/";

    $data = [
        "email"      => $email,
        "reference"  => "palmpay_user_" . $userId, // ✅ Make it unique for PalmPay
        "firstName"  => $firstName,
        "lastName"   => $lastName,
        "webhookUrl" => "https://inyass.com.ng/webhook/palmpay.php",
        "phone"      => $phone
    ];

    return makeApiRequest($url, $data, $apiSecret);
}

function createPagaAccount($firstName, $lastName, $email, $phone, $userId, $apiSecret) {
    $url = "https://api-v1.aspfiy.com/reserve-paga/";

    $data = [
        "email"      => $email,
        "reference"  => "paga_user_" . $userId, // ✅ Make it unique for Paga
        "firstName"  => $firstName,
        "lastName"   => $lastName,
        "webhookUrl" => "https://inyass.com.ng/webhook/paga.php",
        "phone"      => $phone
    ];

    return makeApiRequest($url, $data, $apiSecret);
}

function makeApiRequest($url, $payload, $apiSecret) {
    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiSecret,
        'Content-Type: application/json',
        'accept: application/json'
    ]);

    // Optional Debugging: Remove or write logs instead of echoing
    // curl_setopt($ch, CURLINFO_HEADER_OUT, true);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        // You might want to log this instead of echoing in production
        echo 'Curl error: ' . curl_error($ch);
        curl_close($ch);
        return null;
    }

    // Optional Debugging: Sent headers (disabled for production)
    // $requestHeaders = curl_getinfo($ch, CURLINFO_HEADER_OUT);
 echo "<pre>" . print_r($requestHeaders, true) . "</pre>";

    curl_close($ch);

    return json_decode($response, true);
}

?>
