<?php
session_start();

// Prevent session fixation
session_regenerate_id(true);

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
require 'require/conn.php';
// Sanitize session data before displaying
function sanitizeOutput($data) {
    return htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
}

$fullname = sanitizeOutput($_SESSION['firstName']) . ' ' . sanitizeOutput($_SESSION['lastName']);
$email = sanitizeOutput($_SESSION['email']);
$phone = sanitizeOutput($_SESSION['phone']);
$user_type = sanitizeOutput($_SESSION['type']);


$stmt = $conn->prepare("SELECT firstName, lastName, wallet_balance FROM jamaa WHERE phone = ?");
$stmt->bind_param("s", $phone);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $user = $result->fetch_assoc();
    $firstName = htmlspecialchars($user['firstName']);
    $lastName = htmlspecialchars($user['lastName']);
    $wallet_balance = htmlspecialchars($user['wallet_balance']);
} else {
    echo "User not found.";
    exit();
}

// Add this after fetching user details (after $wallet_balance)
$stmt_pin = $conn->prepare("SELECT transaction_pin FROM jamaa WHERE phone = ?");
$stmt_pin->bind_param("s", $phone);
$stmt_pin->execute();
$result_pin = $stmt_pin->get_result();

$transaction_pin = '';
if ($result_pin->num_rows === 1) {
    $pin_data = $result_pin->fetch_assoc();
    $transaction_pin = $pin_data['transaction_pin'];
}


?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <title>Dashboard</title>
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="images/logo.png" />
    <link rel="apple-touch-icon-precomposed" href="images/logo.png" />
    <!-- Font -->
    <link rel="stylesheet" href="fonts/fonts.css" />
    <!-- Icons -->
    <link rel="stylesheet" href="fonts/icons-alipay.css">
    <link rel="stylesheet" href="styles/bootstrap.css">
    <link rel="stylesheet" href="styles/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="styles/styles.css" />

    <link rel="apple-touch-icon" sizes="192x192" href="app/icons/icon-192x192.png">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        /* Add this CSS to create a 3x3 grid layout */
        .box-service {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 16px; /* Adjust the gap between grid items as needed */
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .box-service li {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            background-color: #f9f9f9; /* Optional: Add background color */
            padding: 16px;
            border-radius: 8px; /* Optional: Add rounded corners */
        }

        .box-service li a {
            text-decoration: none;
            color: inherit;
        }

        .icon-box {
            font-size: 24px; /* Adjust the size of the icon */
            margin-bottom: 8px; /* Space between icon and text */
        }
    </style>
</head>

<body>
    
    <div class="app-header">
        <div class="tf-container">
            <div class="tf-topbar d-flex justify-content-between align-items-center">
                <a class="user-info d-flex justify-content-between align-items-center" href="profile.php">
                    <img src="images/user/user1.jpg" alt="image">

                    <div class="content">
                        <h4 class="white_color"> <?php echo $fullname; ?></h4>
                        <p class="white_color fw_4"><?php echo ucfirst($user_type); ?></p>
                    </div>
                </a>
               
            </div>
        </div>
    </div>
    <div class="card-secton">
        <div class="tf-container">
            <div class="tf-balance-box">
                <div class="balance">
                    <div class="row">
                        <div class="col-6 br-right">
                            <div class="inner-left">
                                <p>Your Balance:</p>
                               <h2>
    <span id="wallet-balance">₦****</span>
    <span id="toggle-eye" class="eye-icon" style="cursor: pointer;">👁️</span>
</h2>

<script>
    const eyeIcon = document.getElementById('toggle-eye');
    const walletBalance = document.getElementById('wallet-balance');

    // Replace with actual wallet balance from PHP
    const rawBalance = "<?php echo $wallet_balance; ?>"; // e.g., 25000.75

    // Format the balance with comma separators and two decimal points
    const formattedBalance = "₦" + parseFloat(rawBalance).toLocaleString('en-NG', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });

    let isVisible = false;

    eyeIcon.addEventListener('click', () => {
        if (isVisible) {
            walletBalance.textContent = '****';
            eyeIcon.textContent = '👁️';
        } else {
            walletBalance.textContent = formattedBalance; // Show formatted number with ₦
            eyeIcon.textContent = '🙈';
        }
        isVisible = !isVisible;
    });
</script>

                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="wallet-footer">
                    <!-- Include Font Awesome CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<ul class="d-flex justify-content-between align-items-center" style="list-style: none; padding: 0;">
    
    <!-- Fund Account -->
    <li class="wallet-card-item" style="text-align: center;">
        <a href="account.php" class="fw_6 text-center" id="btn-popup-down" style="text-decoration: none; color: inherit;">
            <div class="icon-container">
                <i class="fas fa-wallet fa-2x"></i>
            </div>
            <div>Fund Account</div>
        </a>
    </li>

    <!-- Buy Data -->
    <li class="wallet-card-item" style="text-align: center;">
        <a href="buy_data.php" class="fw_6 btn-card-popup" style="text-decoration: none; color: inherit;">
            <div class="icon-container">
                <i class="fas fa-signal fa-2x"></i>
            </div>
            <div>Buy Data</div>
        </a>
    </li>

    <!-- Airtime -->
    <li class="wallet-card-item" style="text-align: center;">
        <a href="buyairtime.php" class="fw_6" style="text-decoration: none; color: inherit;">
            <div class="icon-container">
                <i class="fas fa-mobile-alt fa-2x"></i>
            </div>
            <div>Airtime</div>
        </a>
         </li>

       </ul>

                </div>
            </div>
        </div>

       </div>
    
       
           
       
        
       
  
        
        
         <div class="mt-5 mb-9">
        <div class="tf-container">
         <h3 class="fw_6">Your service</h3>
        
        <ul class="box-service mt-4">
            <li>
                <a href="buy_data.php">
                    <div class="icon-box"><i class="fas fa-signal"></i></div>
                    Buy Data
                </a>
            </li>
            <li>
                <a href="#">
                    <div class="icon-box"><i class="fas fa-mobile-alt"></i></div>
                    Airtime
                </a>
            </li>
            <li>
                <a href="#">
                    <div class="icon-box"><i class="fas fa-file-invoice-dollar"></i></div>
                    Bill
                </a>
            </li>
            <li>
                <a href="#">
                    <div class="icon-box"><i class="fas fa-bolt"></i></div>
                    Electricity
                </a>
            </li>
            
            <li>
                <a href="#">
                    <div class="icon-box"><i class="fas fa-book-open"></i></div>
                    Exam
                </a>
            </li>
            <li>
                <a href="#">
                    <div class="icon-box"><i class="fas fa-sim-card"></i></div>
                    Data Card
                </a>
            </li>
            
            <li>
                <a href="#">
                    <div class="icon-box"><i class="fas fa-credit-card"></i></div>
                    Recharge Card
                </a>
            </li>
            <li>
                <a href="#">
                    <div class="icon-box"><i class="fas fa-id-card"></i></div>
                    Nimc
                </a>
            </li>
            <li>
                <a href="#">
                    <div class="icon-box"><i class="fas fa-address-book"></i></div>
                    Contact
                </a>
            </li>
        </ul>
    </div>
</div>
   
   
  
   
   <?php if (empty($transaction_pin)) : ?>
<!-- Modal for Creating PIN -->
<div id="createPinModal" style="display: block; position: fixed; z-index: 9999; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7);">
    <div style="background: #fff; max-width: 400px; margin: 100px auto; padding: 20px; border-radius: 10px;">
        <h3>Create Transaction PIN</h3>
        <form id="pinForm">
            <input type="password" name="pin" id="pin" maxlength="4" pattern="\d{4}" placeholder="Enter 4-digit PIN" required style="width: 100%; padding: 10px; margin-bottom: 10px;" />
            <button type="submit" style="padding: 10px 20px; background: #28a745; color: #fff; border: none; border-radius: 5px;">Save PIN</button>
        </form>
    </div>
</div>
<?php endif; ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const pinForm = document.getElementById('pinForm');

    if (pinForm) {
        pinForm.addEventListener('submit', function(e) {
            e.preventDefault();

            const pinInput = document.getElementById('pin').value;

            if (!/^\d{4}$/.test(pinInput)) {
                alert('PIN must be exactly 4 digits.');
                return;
            }

            // Send the PIN to PHP for saving
            fetch('save_pin.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'pin=' + encodeURIComponent(pinInput)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('PIN successfully created!');
                    document.getElementById('createPinModal').style.display = 'none';
                    location.reload(); // Optional: Refresh the page or redirect
                } else {
                    alert('Failed to save PIN: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Something went wrong.');
            });
        });
    }
});
</script>

     
    <div class="bottom-navigation-bar">
        <div class="tf-container">
            <ul class="tf-navigation-bar">
                <li ><a class="fw_6 d-flex justify-content-center align-items-center flex-column"
                        href="account.php"> <i class="fas fa-wallet fa-2x"></i> Fund</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="history.php"><i
                            class="icon-history"></i> History</a> </li>
                <li class="active"><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="dashboard.php"><i
                            class="icon-home2"></i> </a>  </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column"
                        href="contact.php">  <i class="fas fa-flag fa-2x"></i></i>
                        Contact</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="profile.php"><i
                            class="icon-user-outline"></i> Profile</a> </li>
            </ul>
            <!-- <span class="line"></span> -->
        </div>
    </div>



 </div>   </div>
    <script type="text/javascript" src="javascript/jquery.min.js"></script>
    <script type="text/javascript" src="javascript/bootstrap.min.js"></script>
    <script type="text/javascript" src="javascript/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="javascript/swiper.js"></script>
    <script type="text/javascript" src="javascript/main.js"></script>
   
</body>

</html>