<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="default">
		<meta http-equiv="Content-Security-Policy" content="default-src * 'self' 'unsafe-inline' 'unsafe-eval' data: gap:">
		<link rel="icon" href="images/favicon-2.png">
		<title>Jetpay - Wallet Mobile Template</title>
		<link href="../css-2?family=Roboto:300,400,400i,500,500i,700,900&display=swap" rel="stylesheet">
		<link rel="stylesheet" href="css/framework7.bundle.min-2.css">
		<link rel="stylesheet" href="css/font-awesome.min-2.css">
		<link rel="stylesheet" href="css/style.css">
	</head>
	<body>
		
		<div id="app">
			<div class="view view-main view-init" data-url="/">
				<div class="page page-home page-with-subnavbar">
					<div class="toolbar tabbar tabbar-labels toolbar-bottom">
						<div class="toolbar-inner">
							<a href="#tab-1" class="tab-link tab-link-active">
								<i class="fa fa-home"></i>
								<p>Home</p>
							</a>
							<a href="#tab-2" class="tab-link">
								<i class="fas fa-history"></i>
								<p>History</p>
							</a>
							<a href="#tab-3" class="tab-link">
								<i class="fas fa-wallet"></i>
								<p>Contact</p>
							</a>
						
							<a href="#tab-5" class="tab-link">
								<i class="fas fa-user"></i>
								<p>Account</p>
							</a>
						</div>
					</div>
					
					<!-- tabs -->
					<div class="tabs-animated-wrap">
					<div class="tabs">
						
						<!-- tabs 1 -->
						<div id="tab-1" class="tab tab-active page-content">
							
							<!-- title -->
							<div class="title-apps padding-middle background-primer">
								<div class="container">
									<div class="row row-no-margin-bottom">
										<div class="col">
											<h3 class="color-white">Sharhi Data</h3>
										</div>
										<div class="col">
											<a href="/notification/">
												<span class="icon-middle margin-left-small float-right color-white">
													<i class="fas fa-bell"></i>
												</span>
											</a>
										</div>
									</div>
								</div>
							</div>
							<!-- end title -->
							
							<!-- profile balance -->
							<div class="border-radius-style background-circle background-primer">
								<div class="container">
									<div class="background-white border-radius padding-box-middle box-shadow">
										<div class="row row-no-margin-bottom">
											<div class="col-60">
												<div class="float-left margin-right-small">
													<img class="people" src="images/author-2.jpg" alt="">
												</div>
												<div class="overflow-hidden">
													<h6><span id="fullName"></h6>
													<p>@Verified User</p>
												</div>
											</div>
										<div class="col-40">
  <button class="buttons float-right letter-spacing margin-top-small">
    <p>
      <strong>Balance:</strong> 
      <span id="walletBalanceDisplay">N***</span>
      <span id="walletBalanceValue" style="display: none;"></span>
      <i class="fas fa-eye toggle-eye" onclick="toggleBalanceVisibility()" style="cursor: pointer; margin-left: 5px;"></i>
    </p>
  </button>
</div>
										</div>
									</div>
								</div>
							</div>
							<!-- end profile balance -->
							
							<!-- separator -->
							<div class="separator"></div>
							<!-- end separator -->
							<!-- menus -->
							<div class="menus">
								<div class="container">
									<div class="row">
									    
									    <div class="col">
											<a href="buydata.html">
												<div class="background-white text-center border-radius padding-box box-shadow">
													<span class="icon-big icon-color-teal"><i class="fa fa-wifi"></i></span>
													<h6 class="font-weight-500">Buy Data</h6>
												</div>
											</a>
										</div>
											<div class="col">
											<a href="buyairtime.html">
												<div class="background-white text-center border-radius padding-box box-shadow">
													<span class="icon-big icon-color-purple"><i class="fa fa-gift"></i></span>
													<h6 class="font-weight-500">Airtime</h6>
												</div>
											</a>
										</div>
											<div class="col">
											<a href="account.html">
												<div class="background-white text-center border-radius padding-box box-shadow">
													<span class="icon-big icon-color-pink"><i class="fa fa-donate"></i></span>
													<h6 class="font-weight-500">Fund</h6>
												</div>
											</a>
										</div>
										
										
										
									    
									    
									    
									    
									
									
									
									</div>
									<div class="row">
										
										
										
										
										
										
										<div class="col">
											<a href="/ticket/">
												<div class="background-white text-center border-radius padding-box box-shadow">
													<span class="icon-big icon-color-orange"><i class="fa fa-ticket-alt"></i></span>
													<h6 class="font-weight-500">TV</h6>
												</div>
											</a>
										</div>
										<div class="col">
											<a href="/events/">
												<div class="background-white text-center border-radius padding-box box-shadow">
													<span class="icon-big icon-color-blue"><i class="fa fa-calendar-alt"></i></span>
													<h6 class="font-weight-500">Data Card</h6>
												</div>
											</a>
										</div>
										
											<div class="col">
											<a href="/withdraw/">
												<div class="background-white text-center border-radius padding-box box-shadow">
													<span class="icon-big icon-color-green"><i class="fa fa-arrow-alt-circle-down"></i></span>
													<h6 class="font-weight-500">Exam</h6>
												</div>
											</a>
										</div>
									</div>
									<div class="row">
										<div class="col">
											<a href="/electricity/">
												<div class="background-white text-center border-radius padding-box box-shadow">
													<span class="icon-big icon-color-yellow"><i class="fa fa-lightbulb"></i></span>
													<h6 class="font-weight-500">Electricity</h6>
												</div>
											</a>
										</div>
									
									
									
									
										<div class="col">
											<a href="/transfer/">
												<div class="background-white text-center border-radius padding-box box-shadow">
													<span class="icon-big icon-color-red"><i class="fa fa-redo"></i></span>
													<h6 class="font-weight-500">About</h6>
												</div>
											</a>
										</div>
									
									
										<div class="col">
											<a href="walleth.html">
												<div class="background-white text-center border-radius padding-box box-shadow">
													<span class="icon-big icon-color-lime"><i class="fa fa-bars"></i></span>
													<h6 class="font-weight-500">Wallet History</h6>
												</div>
											</a>
										</div>
									</div>
								</div>
							</div>
							<!-- end menus -->
							<!-- separator -->
							<div class="separator"></div>
							<!-- end separator -->
							<!-- follow us -->
							<div class="container">
								<div class="background-white border-radius box-shadow padding-box-middle text-center">
									<h4 class="margin-bottom-small">Follow us on :</h4>
									<ul>
										<li>
											<a href=""><span class="icon-small icon-width socmed-bg-facebook color-white">
												<i class="fab fa-facebook-f"></i>
											</span></a>
										</li>
										<li>
											<a href=""><span class="icon-small icon-width socmed-bg-twitter color-white">
												<i class="fab fa-twitter"></i>
											</span></a>
										</li>
										<li>
											<a href=""><span class="icon-small icon-width socmed-bg-whatsapp color-white">
												<i class="fab fa-whatsapp"></i>
											</span></a>
										</li>
										<li>
											<a href=""><span class="icon-small icon-width socmed-bg-google color-white">
												<i class="fab fa-google"></i>
											</span></a>
										</li>
									</ul>
								</div>
							</div>
							<!-- end follow us -->
							<!-- separator -->
							<div class="separator-bottom"></div>
							<!-- end separator -->
						</div>
					
							
					
						<!-- tabs 3 -->
					
						<!-- end tabs 3 -->
						
					</div>
					</div>
					<!-- end tabs -->
				</div>
			</div>
		</div>
		<!-- script -->
		<script src="js/framework7.bundle.min-2.js"></script>
		<script src="js/routes-2.js"></script>
		<script src="js/app-2.js"></script>
		
		
		
		<!-- end script -->
		
		
		
		 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
 <script>
  // Fetch user data from localStorage
  const storedPhone = localStorage.getItem('phone');

  if (!storedPhone) {
    // Redirect to login if no phone is stored
    window.location.href = "login.html";
  }

  // Fetch user data from the server
  fetch('https://inyass.com.ng/dataa/application/dashboard.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify({ phone: storedPhone }),
  })
  .then(response => {
    if (!response.ok) {
      throw new Error(`HTTP error! Status: ${response.status}`);
    }
    return response.json();
  })
  .then(data => {
    if (data.status === "success") {
      // Combine firstName and lastName into fullName
      const fullName = `${data.firstName} ${data.lastName}`;
      document.getElementById('fullName').textContent = fullName;

      // Store the wallet balance in a hidden span
      document.getElementById('walletBalanceValue').textContent = `₦${data.wallet_balance}`;
    } else {
      Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: data.message,
      });
    }
  })
  .catch(error => {
    console.error('Error:', error);
    Swal.fire({
      icon: 'error',
      title: 'Oops...',
      text: 'An error occurred. Please try again.',
    });
  });

  // Function to toggle balance visibility
  function toggleBalanceVisibility() {
    const balanceDisplay = document.getElementById('walletBalanceDisplay');
    const balanceValue = document.getElementById('walletBalanceValue');
    const eyeIcon = document.querySelector('.toggle-eye');

    if (balanceDisplay.textContent === 'N***') {
      // Show the actual balance
      balanceDisplay.textContent = balanceValue.textContent;
      eyeIcon.classList.remove('fa-eye');
      eyeIcon.classList.add('fa-eye-slash');
    } else {
      // Hide the balance
      balanceDisplay.textContent = 'N***';
      eyeIcon.classList.remove('fa-eye-slash');
      eyeIcon.classList.add('fa-eye');
    }
  }

  // Logout function
  function logout() {
    localStorage.removeItem('phone');
    window.location.href = "../login.html";
  }
</script>
	</body>
</html>