<?php

/**
 * Make an API request using cURL.
 */
function makeApiRequest($url, $data, $apiSecret) {
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiSecret,
        'Content-Type: application/json',
        'accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);

    // Return API response
    return ($httpCode == 200) ? json_decode($response, true) : false;
}

/**
 * Create a PalmPay account using the API.
 */
function createPalmPayAccount($firstName, $lastName, $email, $phone, $userId, $apiSecret) {
    $url = "https://api-v1.aspfiy.com/reserve-palmpay/";
    $data = [
        "email" => $email,
        "reference" => "user_" . $userId, 
        "firstName" => $firstName,
        "lastName" => $lastName,
        "webhookUrl" => "https://inyass.com.ng/webhook/palmpay.php",
        "phone" => $phone
    ];

    return makeApiRequest($url, $data, $apiSecret);
}

/**
 * Create a Paga account using the API.
 */
function createPagaAccount($firstName, $lastName, $email, $phone, $userId, $apiSecret) {
    $url = "https://api-v1.aspfiy.com/reserve-paga/";
    $data = [
        "email" => $email,
        "reference" => "user_" . $userId,
        "firstName" => $firstName,
        "lastName" => $lastName,
        "webhookUrl" => "https://inyass.com.ng/webhook/paga.php",
        "phone" => $phone
    ];

    return makeApiRequest($url, $data, $apiSecret);
}
?>
