<?php
session_start();

// Prevent session fixation
session_regenerate_id(true);

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

require 'require/conn.php';

// Sanitize session data before displaying
function sanitizeOutput($data) {
    return htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
}

$fullname = sanitizeOutput($_SESSION['firstName']) . ' ' . sanitizeOutput($_SESSION['lastName']);
$email = sanitizeOutput($_SESSION['email']);
$phone = sanitizeOutput($_SESSION['phone']);
$user_type = sanitizeOutput($_SESSION['type']);

// Fetch user details including wallet balance, transaction pin, and other account details
$stmt = $conn->prepare("SELECT firstName, lastName, wallet_balance, created_at, palmpay_account_no, palmpay_account_name, paga_account_name, paga_account_id, transaction_pin FROM jamaa WHERE phone = ?");
$stmt->bind_param("s", $phone);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $user = $result->fetch_assoc();
    $firstName = sanitizeOutput($user['firstName']);
    $lastName = sanitizeOutput($user['lastName']);
    $wallet_balance = sanitizeOutput($user['wallet_balance']);
    $created_at = sanitizeOutput($user['created_at']);
    $palmpay_account_no = sanitizeOutput($user['palmpay_account_no']);
    $palmpay_account_name = sanitizeOutput($user['palmpay_account_name']);
    $paga_account_name = sanitizeOutput($user['paga_account_name']);
    $paga_account_id = sanitizeOutput($user['paga_account_id']);
    $transaction_pin = sanitizeOutput($user['transaction_pin']);
} else {
    echo "User not found.";
    exit();
}
?>
























<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <title>Dashboard</title>
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="images/logo.png" />
    <link rel="apple-touch-icon-precomposed" href="images/logo.png" />
    <!-- Font -->
    <link rel="stylesheet" href="fonts/fonts.css" />
    <!-- Icons -->
    <link rel="stylesheet" href="fonts/icons-alipay.css">
    <link rel="stylesheet" href="styles/bootstrap.css">
    <link rel="stylesheet" href="styles/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="styles/styles.css" />

    <link rel="apple-touch-icon" sizes="192x192" href="app/icons/icon-192x192.png">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        /* Add this CSS to create a 3x3 grid layout */
        .box-service {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 16px; /* Adjust the gap between grid items as needed */
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .box-service li {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            background-color: #f9f9f9; /* Optional: Add background color */
            padding: 16px;
            border-radius: 8px; /* Optional: Add rounded corners */
        }

        .box-service li a {
            text-decoration: none;
            color: inherit;
        }

        .icon-box {
            font-size: 24px; /* Adjust the size of the icon */
            margin-bottom: 8px; /* Space between icon and text */
        }
    </style>
</head>

<body>
    
    <div class="app-header">
        <div class="tf-container">
            <div class="tf-topbar d-flex justify-content-between align-items-center">
                <a class="user-info d-flex justify-content-between align-items-center" href="profile.php">
                    <img src="images/user/user1.jpg" alt="image">

                    <div class="content">
                        <h4 class="white_color"> <?php echo $fullname; ?></h4>
                        <p class="white_color fw_4"><?php echo ucfirst($user_type); ?></p>
                    </div>
                </a>
               
            </div>
        </div>
    </div>
    <div class="card-secton">
        <div class="tf-container">
            <div class="tf-balance-box">
                <div class="balance">
                    <div class="row">
                        <div class="col-6 br-right">
                            <div class="inner-left">
                                <p>Your Balance:</p>
                               <h2>
    <span id="wallet-balance">₦****</span>
    <span id="toggle-eye" class="eye-icon" style="cursor: pointer;">👁️</span>
</h2>

<script>
    const eyeIcon = document.getElementById('toggle-eye');
    const walletBalance = document.getElementById('wallet-balance');

    // Replace with actual wallet balance from PHP
    const rawBalance = "<?php echo $wallet_balance; ?>"; // e.g., 25000.75

    // Format the balance with comma separators and two decimal points
    const formattedBalance = "₦" + parseFloat(rawBalance).toLocaleString('en-NG', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });

    let isVisible = false;

    eyeIcon.addEventListener('click', () => {
        if (isVisible) {
            walletBalance.textContent = '****';
            eyeIcon.textContent = '👁️';
        } else {
            walletBalance.textContent = formattedBalance; // Show formatted number with ₦
            eyeIcon.textContent = '🙈';
        }
        isVisible = !isVisible;
    });
</script>

                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="wallet-footer">
                    <!-- Include Font Awesome CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<ul class="d-flex justify-content-between align-items-center" style="list-style: none; padding: 0;">
    
    <!-- Fund Account -->
    <li class="wallet-card-item" style="text-align: center;">
        <a href="javascript:void(0);" class="fw_6 text-center" id="btn-popup-down" style="text-decoration: none; color: inherit;">
            <div class="icon-container">
                <i class="fas fa-wallet fa-2x"></i>
            </div>
            <div>Fund Account</div>
        </a>
    </li>

    <!-- Buy Data -->
    <li class="wallet-card-item" style="text-align: center;">
        <a href="buy_data.php" class="fw_6 btn-card-popup" style="text-decoration: none; color: inherit;">
            <div class="icon-container">
                <i class="fas fa-signal fa-2x"></i>
            </div>
            <div>Buy Data</div>
        </a>
    </li>

    <!-- Airtime -->
    <li class="wallet-card-item" style="text-align: center;">
        <a href="buyairtime.php" class="fw_6" style="text-decoration: none; color: inherit;">
            <div class="icon-container">
                <i class="fas fa-mobile-alt fa-2x"></i>
            </div>
            <div>Airtime</div>
        </a>
         </li>

       </ul>

                </div>
            </div>
        </div>

       </div>
    
       
           
       
        
       
  
        
        
         <div class="mt-5 mb-9">
        <div class="tf-container">
         <h3 class="fw_6">Fund Your Account</h3>
        
           <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@200&display=swap" rel="stylesheet">
    <style>
  


    

        .card {
            width: 380px;
            height: 220px;
            background: url("card.jpg");
            background-position: center;
            background-size: cover;
            border-radius: 20px;
            padding: 10px;
            color: #fff;
            position: relative;
            box-shadow: 0 18px 18px 7px gray;
            transition: all 0.5s;
            cursor: pointer;
        }

        .card:hover {
            transform: scale(1.02);
        }

        .card::after {
            content: "";
            width: 100%;
            height: 100%;
            background: rgba(30, 57, 128, 0.8);
            position: absolute;
            clip-path: polygon(31% 13%, 51% 49%, 85% 65%, 100% 100%, 0 99%, 0% 60%, 0 0);
            top: 0;
            left: 0;
            border-radius: 20px;
        }

        .top {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 45px 28px;
            z-index: 1;
            position: relative;
        }

        .top_left {
            font-size: 1.2rem;
        }

        .top_right {
            font-size: 1.2rem;
            font-weight: 600;
        }

        .bottom {
            position: absolute;
            bottom: 22px;
            left: 28px;
            font-size: 1rem;
            letter-spacing: 1.3px;
            z-index: 1;
        }

        .bottom .bottom_p span {
            display: block;
            padding-bottom: 10px;
            color: lightgray;
        }

        .tooltip {
            visibility: hidden;
            background-color: #333;
            color: #fff;
            text-align: center;
            border-radius: 5px;
            padding: 6px 10px;
            position: absolute;
            z-index: 2;
            bottom: 100%;
            left: 50%;
            transform: translateX(-50%);
            opacity: 0;
            transition: opacity 0.3s;
            font-size: 12px;
        }

        .card.copied .tooltip {
            visibility: visible;
            opacity: 1;
        }

        .generate-button {
            display: inline-block;
            margin-top: 10px;
            padding: 10px 15px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            text-align: center;
            cursor: pointer;
            text-decoration: none;
            z-index: 1;
            position: relative;
        }

        .generate-button:hover {
            background-color: #0056b3;
        }

    </style>




<!-- Palmpay Account Card -->
<div class="card" onclick="copyToClipboard('<?php echo $palmpay_account_no; ?>', this)">
    <div class="top">
        <p class="top_left">PalmPay</p>
        <p class="top_right">Instant Transfer</p>
    </div>
    <div class="bottom">
        <?php if (!empty($palmpay_account_no)) : ?>
            <p class="bottom_p">
                <span><?php echo $palmpay_account_name; ?></span>
                <?php echo $palmpay_account_no; ?>
            </p>
        <?php else : ?>
            <p>No PalmPay Account Found.</p>
            <form method="post" action="generate_account.php" onclick="event.stopPropagation();">
                <input type="hidden" name="account_type" value="palmpay">
                <button class="generate-button" type="submit">Generate Palmpay Account</button>
            </form>
        <?php endif; ?>
    </div>
    <div class="tooltip">Copied!</div>
</div>

<br> <br>

<!-- Paga Account Card -->
<div class="card" onclick="copyToClipboard('<?php echo $paga_account_id; ?>', this)">
    <div class="top">
        <p class="top_left">Paga</p>
        <p class="top_right">Instant Transfer</p>
    </div>
    <div class="bottom">
        <?php if (!empty($paga_account_id)) : ?>
            <p class="bottom_p">
                <span><?php echo $paga_account_name; ?></span>
                <?php echo $paga_account_id; ?>
            </p>
        <?php else : ?>
            <p>No Paga Account Found.</p>
            <form method="post" action="generate_account.php" onclick="event.stopPropagation();">
                <input type="hidden" name="account_type" value="paga">
                <button class="generate-button" type="submit">Generate Paga Account</button>
            </form>
        <?php endif; ?>
    </div>
    <div class="tooltip">Copied!</div>
</div>
    </div>


<script>
    function copyToClipboard(accountNo, element) {
        if (!accountNo) {
            alert("No account number to copy!");
            return;
        }

        const tempInput = document.createElement("textarea");
        tempInput.value = accountNo;
        document.body.appendChild(tempInput);

        tempInput.select();
        tempInput.setSelectionRange(0, 99999);
        document.execCommand("copy");
        document.body.removeChild(tempInput);

        const allCards = document.querySelectorAll('.card');
        allCards.forEach(card => card.classList.remove('copied'));

        element.classList.add('copied');

        setTimeout(() => {
            element.classList.remove('Account No. copied');
        }, 2000);
    }
</script>
       
       
       
       
    </div>
</div>
   
   
  
   
   <?php if (empty($transaction_pin)) : ?>
<!-- Modal for Creating PIN -->
<div id="createPinModal" style="display: block; position: fixed; z-index: 9999; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7);">
    <div style="background: #fff; max-width: 400px; margin: 100px auto; padding: 20px; border-radius: 10px;">
        <h3>Create Transaction PIN</h3>
        <form id="pinForm">
            <input type="password" name="pin" id="pin" maxlength="4" pattern="\d{4}" placeholder="Enter 4-digit PIN" required style="width: 100%; padding: 10px; margin-bottom: 10px;" />
            <button type="submit" style="padding: 10px 20px; background: #28a745; color: #fff; border: none; border-radius: 5px;">Save PIN</button>
        </form>
    </div>
</div>
<?php endif; ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const pinForm = document.getElementById('pinForm');

    if (pinForm) {
        pinForm.addEventListener('submit', function(e) {
            e.preventDefault();

            const pinInput = document.getElementById('pin').value;

            if (!/^\d{4}$/.test(pinInput)) {
                alert('PIN must be exactly 4 digits.');
                return;
            }

            // Send the PIN to PHP for saving
            fetch('save_pin.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'pin=' + encodeURIComponent(pinInput)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('PIN successfully created!');
                    document.getElementById('createPinModal').style.display = 'none';
                    location.reload(); // Optional: Refresh the page or redirect
                } else {
                    alert('Failed to save PIN: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Something went wrong.');
            });
        });
    }
});
</script>

     
    <div class="bottom-navigation-bar">
        <div class="tf-container">
            <ul class="tf-navigation-bar">
                <li ><a class="fw_6 d-flex justify-content-center align-items-center flex-column"
                        href="account.php"> <i class="fas fa-wallet fa-2x"></i> Fund</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="history.php"><i
                            class="icon-history"></i> History</a> </li>
                <li class="active"><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="dashboard.php"><i
                            class="icon-home2"></i> </a>  </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column"
                        href="contact.php">  <i class="fas fa-flag fa-2x"></i></i>
                        Contact</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="profile.php"><i
                            class="icon-user-outline"></i> Profile</a> </li>
            </ul>
            <!-- <span class="line"></span> -->
        </div>
    </div>



 </div>   </div>
    <script type="text/javascript" src="javascript/jquery.min.js"></script>
    <script type="text/javascript" src="javascript/bootstrap.min.js"></script>
    <script type="text/javascript" src="javascript/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="javascript/swiper.js"></script>
    <script type="text/javascript" src="javascript/main.js"></script>
   
</body>

</html>
