<?php
require 'require/conn.php';
session_start();

// Fetch networks from the database
$network_query = "SELECT network_name FROM network WHERE status = 'On'";
$network_result = $conn->query($network_query);

// Fetch airtime status from the database
$airtime_query = "SELECT airtime_name FROM airtime_status WHERE status = 'On'";
$airtime_result = $conn->query($airtime_query);

// Handle form submission to add a new data plan
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_plan'])) {
    $network = $_POST['network'];
    $airtime_status = $_POST['airtime_status'];
    $user_price = $_POST['user_price'];
    $api_price = $_POST['api_price'];

    // Prepare statement to insert data securely
    $stmt = $conn->prepare("INSERT INTO airtime_plans (network, airtime_status, user_price, api_price) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssdd", $network, $airtime_status, $user_price, $api_price);

    if ($stmt->execute()) {
        echo "<script>
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: 'Data Plan Added Successfully!',
                timer: 2000,
                showConfirmButton: false
            });
        </script>";
    } else {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'Failed to add data plan!',
                timer: 2000,
                showConfirmButton: false
            });
        </script>";
    }
    $stmt->close();
}

// Fetch all data plans for display
$airtime_plans_query = "SELECT * FROM airtime_plans";
$airtime_plans_result = $conn->query($airtime_plans_query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Data Plan</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        #add-form {
            display: none; /* Hide the form by default */
            margin-top: 20px;
        }
    </style>
    <script>
        function toggleAddForm() {
            const form = document.getElementById('add-form');
            if (form.style.display === 'none') {
                form.style.display = 'block'; // Show the form
            } else {
                form.style.display = 'none'; // Hide the form
            }
        }
    </script>
</head>
<body>
    <h1>Data Plans List</h1>
    <!-- Button to toggle the Add Data Plan form -->
    <button onclick="toggleAddForm()">Show Add Form</button>

    <!-- Add Data Plan Form (hidden by default) -->
    <div id="add-form">
        <h2>Add Data Plan</h2>
        <form method="post">
            <!-- Network Dropdown -->
            <label for="network">Select Network:</label>
            <select id="network" name="network" required>
                <option value="">-- Select Network --</option>
                <?php while ($row = $network_result->fetch_assoc()) { ?>
                    <option value="<?= htmlspecialchars($row['network_name']) ?>"><?= htmlspecialchars($row['network_name']) ?></option>
                <?php } ?>
            </select>
            <br>

            <!-- Airtime Status Dropdown -->
            <label for="airtime_status">Select Airtime Status:</label>
            <select id="airtime_status" name="airtime_status" required>
                <option value="">-- Select Airtime Status --</option>
                <?php while ($row = $airtime_result->fetch_assoc()) { ?>
                    <option value="<?= htmlspecialchars($row['airtime_name']) ?>"><?= htmlspecialchars($row['airtime_name']) ?></option>
                <?php } ?>
            </select>
            <br>

            <!-- User Price -->
            <label for="user_price">User Price:</label>
            <input type="number" id="user_price" name="user_price" step="0.01" required>
            <br>

            <!-- API Price -->
            <label for="api_price">API Price:</label>
            <input type="number" id="api_price" name="api_price" step="0.01" required>
            <br>

            <button type="submit" name="add_plan">Add Data Plan</button>
        </form>
    </div>

    <!-- Data Plans List -->
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Network</th>
                <th>Airtime Status</th>
                <th>User Price</th>
                <th>API Price</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = $airtime_plans_result->fetch_assoc()) { ?>
                <tr>
                    <td><?= htmlspecialchars($row['id']) ?></td>
                    <td><?= htmlspecialchars($row['network']) ?></td>
                    <td><?= htmlspecialchars($row['airtime_status']) ?></td>
                    <td><?= htmlspecialchars($row['user_price']) ?></td>
                    <td><?= htmlspecialchars($row['api_price']) ?></td>
                    <td>
                        <!-- Edit Button -->
                        <a href="edit_vtu.php?id=<?= $row['id'] ?>">
                            <button>Edit</button>
                        </a>
                        <!-- Delete Button -->
                        <a href="?delete_id=<?= $row['id'] ?>" onclick="return confirm('Are you sure you want to delete this plan?');">
                            <button>Delete</button>
                        </a>
                    </td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</body>
</html>