<?php
require 'require/conn.php';

// Check if the ID parameter is provided in the URL
if (!isset($_GET['id'])) {
    die("ID parameter is missing.");
}

$id = $_GET['id'];

// Fetch the data plan details from the database
$query = "SELECT * FROM data_plans WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if (!$row) {
    die("Data plan not found.");
}

// Fetch networks from the database
$network_query = "SELECT network_name FROM network WHERE status = 'On'";
$network_result = $conn->query($network_query);

// Fetch gifting status (data plans) from the database
$plan_query = "SELECT plan_name FROM data_status WHERE status = 'On'";
$plan_result = $conn->query($plan_query);

// Handle form submission to update the data plan
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $network = $_POST['network'];
    $data_status = $_POST['gifting_status'];
    $data_name = $_POST['data_name'];
    $dataplan_id = $_POST['dataplan_id'];
    $user_price = $_POST['user_price'];
    $api_price = $_POST['api_price'];

    // Prepare the update query
    $update_query = "UPDATE data_plans SET network = ?, data_status = ?, data_name = ?, dataplan_id = ?, user_price = ?, api_price = ? WHERE id = ?";
    $stmt = $conn->prepare($update_query);
    $stmt->bind_param("ssssddi", $network, $data_status, $data_name, $dataplan_id, $user_price, $api_price, $id);

    if ($stmt->execute()) {
        echo "<script>
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: 'Data Plan Updated Successfully!',
                timer: 2000,
                showConfirmButton: false
            }).then(() => {
                window.location.href = 'index.php'; // Redirect to the main page
            });
        </script>";
    } else {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: 'Failed to update data plan!',
                timer: 2000,
                showConfirmButton: false
            });
        </script>";
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Data Plan</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
    <h1>Edit Data Plan</h1>
    <form method="post">
        <input type="hidden" name="id" value="<?= $row['id'] ?>">

        <!-- Network Dropdown -->
        <label for="network">Select Network:</label>
        <select id="network" name="network" required>
            <option value="">-- Select Network --</option>
            <?php
            $network_result->data_seek(0); // Reset the pointer to the beginning of the result set
            while ($network_row = $network_result->fetch_assoc()) {
                $selected = ($network_row['network_name'] == $row['network']) ? 'selected' : '';
                echo "<option value='" . htmlspecialchars($network_row['network_name']) . "' $selected>" . htmlspecialchars($network_row['network_name']) . "</option>";
            }
            ?>
        </select>
        <br>

        <!-- Data Plan Dropdown -->
        <label for="gifting_status">Select Data Plan:</label>
        <select id="gifting_status" name="gifting_status" required>
            <option value="">-- Select Data Plan --</option>
            <?php
            $plan_result->data_seek(0); // Reset the pointer to the beginning of the result set
            while ($plan_row = $plan_result->fetch_assoc()) {
                $selected = ($plan_row['plan_name'] == $row['data_status']) ? 'selected' : '';
                echo "<option value='" . htmlspecialchars($plan_row['plan_name']) . "' $selected>" . htmlspecialchars($plan_row['plan_name']) . "</option>";
            }
            ?>
        </select>
        <br>

        <!-- Other Fields -->
        <label for="data_name">Data Name:</label>
        <input type="text" id="data_name" name="data_name" value="<?= htmlspecialchars($row['data_name']) ?>" required>
        <br>

        <label for="dataplan_id">Data Plan ID:</label>
        <input type="text" id="dataplan_id" name="dataplan_id" value="<?= htmlspecialchars($row['dataplan_id']) ?>" required>
        <br>

        <label for="user_price">User Price:</label>
        <input type="number" id="user_price" name="user_price" step="0.01" value="<?= htmlspecialchars($row['user_price']) ?>" required>
        <br>

        <label for="api_price">API Price:</label>
        <input type="number" id="api_price" name="api_price" step="0.01" value="<?= htmlspecialchars($row['api_price']) ?>" required>
        <br>

        <button type="submit">Update Data Plan</button>
    </form>
</body>
</html>