<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    // Redirect to login page if not logged in
    header("Location: login.html");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            background-color: #f4f4f4;
        }
        h2 {
            color: #333;
        }
        .btn-container {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            max-width: 400px;
            margin: 20px auto;
        }
        .btn {
            display: inline-block;
            padding: 15px;
            font-size: 16px;
            background-color: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            text-align: center;
            transition: 0.3s;
        }
        .btn:hover {
            background-color: #0056b3;
        }
        .logout-btn {
            background-color: #dc3545;
        }
        .logout-btn:hover {
            background-color: #a71d2a;
        }
    </style>
</head>
<body>
    <h2>Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?>!</h2>

    <div class="btn-container">
        <a href="api.php" class="btn">API</a>
        <a href="data.php" class="btn">Data</a>
        <a href="vtu.php" class="btn">VTU</a>
        <a href="exam.php" class="btn">Exam</a>
        <a href="tv.php" class="btn">TV</a>
        <a href="nimc.php" class="btn">NIMC</a>
        <a href="nepa.php" class="btn">NEPA</a>
        <a href="users.php" class="btn">Users</a>
        <a href="settings.php" class="btn">Settings</a>
    </div>

    <br>
    <a href="logout.php" class="btn logout-btn">Logout</a>
</body>
</html>
