<?php
session_start();
require 'require/conn.php'; // Secure Database Connection

// Prevent unauthorized access
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit();
}

function cleanInput($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

// Fetch existing API settings
$query = "SELECT * FROM api_settings LIMIT 1";
$result = $conn->query($query);
$apiData = $result->fetch_assoc() ?? [
    'api_key' => '',
    'data_url' => '',
    'vtu_url' => '',
    'nepa_url' => '',
    'nimc_url' => '',
    'nepbil_url' => '',
    'tv_url' => '',
    'exam_url' => ''
];

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $api_key = cleanInput($_POST['api_key']);
    $data_url = cleanInput($_POST['data_url']);
    $vtu_url = cleanInput($_POST['vtu_url']);
    $nepa_url = cleanInput($_POST['nepa_url']);
    $nimc_url = cleanInput($_POST['nimc_url']);
    $nepbil_url = cleanInput($_POST['nepbil_url']);
    $tv_url = cleanInput($_POST['tv_url']);
    $exam_url = cleanInput($_POST['exam_url']);

    // Insert or update the record
    if ($result->num_rows > 0) {
        $stmt = $conn->prepare("UPDATE api_settings SET api_key=?, data_url=?, vtu_url=?, nepa_url=?, nimc_url=?, nepbil_url=?, tv_url=?, exam_url=?");
    } else {
        $stmt = $conn->prepare("INSERT INTO api_settings (api_key, data_url, vtu_url, nepa_url, nimc_url, nepbil_url, tv_url, exam_url) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    }
    
    $stmt->bind_param("ssssssss", $api_key, $data_url, $vtu_url, $nepa_url, $nimc_url, $nepbil_url, $tv_url, $exam_url);
    
    if ($stmt->execute()) {
        echo "<script>
    alert('API Settings Updated Successfully!');
    window.location.href = 'api.php'; // Redirect to avoid form resubmission
</script>";

    } else {
        echo "<script>alert('Error saving API settings!');</script>";
    }
    
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>API Settings</title>
</head>
<body>
    <h2>API Settings</h2>
    <form method="POST">
        <label>API Key:</label>
        <input type="text" name="api_key" value="<?php echo $apiData['api_key']; ?>" required><br>

        <label>Data URL:</label>
        <input type="url" name="data_url" value="<?php echo $apiData['data_url']; ?>"><br>

        <label>VTU URL:</label>
        <input type="url" name="vtu_url" value="<?php echo $apiData['vtu_url']; ?>"><br>

        <label>NEPA URL:</label>
        <input type="url" name="nepa_url" value="<?php echo $apiData['nepa_url']; ?>"><br>

        <label>NIMC URL:</label>
        <input type="url" name="nimc_url" value="<?php echo $apiData['nimc_url']; ?>"><br>

        <label>NEP Bill URL:</label>
        <input type="url" name="nepbil_url" value="<?php echo $apiData['nepbil_url']; ?>"><br>

        <label>TV URL:</label>
        <input type="url" name="tv_url" value="<?php echo $apiData['tv_url']; ?>"><br>

        <label>Exam URL:</label>
        <input type="url" name="exam_url" value="<?php echo $apiData['exam_url']; ?>"><br>

        <button type="submit">Save API Settings</button>
    </form>
</body>
</html>
